#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "readCharacter/readCharacter.h"
#include "openFile/openFile.h"
#include "parser/parser.h"
#include "error_codes.h"


int 
main (int argc, char **argv)
{
  int parse_ret;
  
  cmd_args args;
  
  
  parse_ret = parser(args, argc, argv);
  
  if (parse_ret == ERR_CHAR_LENGTH)
    {
      fprintf(stderr, "Too many characters\n");
      return ERR_CHAR_LENGTH;
    }
  else if (parse_ret == ARG_LIMIT_EXCEEDED)
    {
      fprintf(stderr, "Too many arguments\n");
      return ARG_LIMIT_EXCEEDED;
    }
  else if (parse_ret == INVALID_FILE_OR_ARG)
    {
      fprintf(stderr, "Invalid file or argument\n");
      return INVALID_FILE_OR_ARG;
    }
  
  return 0;

}







  


